<?php
// setup.php
mysqli_report(MYSQLI_REPORT_OFF);

// Include the database configuration
require_once 'config/database.php';

// SQL content from original files
$database_sql = <<<SQL
-- phpMyAdmin SQL Dump
-- version 5.2.1
-- https://www.phpmyadmin.net/
--
-- Host: 127.0.0.1
-- Generation Time: Aug 23, 2025 at 07:51 AM
-- Server version: 10.4.32-MariaDB
-- PHP Version: 8.2.12

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+00:00";

--
-- Database: `affirm_sales`
--

-- --------------------------------------------------------

--
-- Table structure for table `sales_records`
--

CREATE TABLE IF NOT EXISTS `sales_records` (
  `id` int(11) NOT NULL PRIMARY KEY AUTO_INCREMENT,
  `appt_id` varchar(255) DEFAULT NULL,
  `submission_date` date DEFAULT NULL,
  `agent_name` varchar(255) DEFAULT NULL,
  `campaign` varchar(255) DEFAULT NULL,
  `date_of_appt` date DEFAULT NULL,
  `time_of_appt` time DEFAULT NULL,
  `cleaning_situation` varchar(255) DEFAULT NULL,
  `frequency` varchar(255) DEFAULT NULL,
  `phone` varchar(20) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `contact_name` varchar(255) DEFAULT NULL,
  `contact_title` varchar(255) DEFAULT NULL,
  `business_name` varchar(255) DEFAULT NULL,
  `address` text DEFAULT NULL,
  `customer_note` text DEFAULT NULL,
  `status` enum('Reviewing','Valid','Invalid','Credit','Credit Till Res','Reschedule','Duplicate','Follow-up','Out Of Coverage','DNC','Decline','Invoiced') DEFAULT 'Reviewing',
  `user_id` int(11) DEFAULT NULL,
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `users`
--

CREATE TABLE IF NOT EXISTS `users` (
  `id` int(11) NOT NULL PRIMARY KEY AUTO_INCREMENT,
  `username` varchar(50) NOT NULL UNIQUE,
  `password` varchar(255) NOT NULL,
  `role` enum('Admin','Agent') NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `users`
--

INSERT IGNORE INTO `users` (`id`, `username`, `password`, `role`) VALUES
(1, 'admin', 'admin', 'Admin');

--
-- Constraints for dumped tables
--

--
-- Constraints for table `sales_records`
--
ALTER TABLE `sales_records`
  ADD CONSTRAINT `sales_records_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`);
COMMIT;
SQL;

$login_history_sql = <<<SQL
CREATE TABLE IF NOT EXISTS `login_history` (
  `id` INT AUTO_INCREMENT PRIMARY KEY,
  `user_id` INT,
  `login_time` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  `ip_address` VARCHAR(45),
  `status` ENUM('success', 'failed') NOT NULL,
  FOREIGN KEY (user_id) REFERENCES users(id)
);
SQL;

$comments_sql = <<<SQL
CREATE TABLE IF NOT EXISTS `comments` (
  `id` INT AUTO_INCREMENT PRIMARY KEY,
  `record_id` INT,
  `user_id` INT,
  `comment` TEXT,
  `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  FOREIGN KEY (record_id) REFERENCES sales_records(id) ON DELETE CASCADE,
  FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE SET NULL
);
SQL;


// Create a new mysqli connection for setup purposes
$conn_setup = new mysqli(DB_SERVER, DB_USERNAME, DB_PASSWORD);

// Check connection
if ($conn_setup->connect_error) {
    die("Connection failed: " . $conn_setup->connect_error);
}

// Create the database
if ($conn_setup->query("CREATE DATABASE IF NOT EXISTS " . DB_NAME) === TRUE) {
    echo "Database created successfully or already exists.<br>";
} else {
    echo "Error creating database: " . $conn_setup->error . "<br>";
}

// Close the setup connection
$conn_setup->close();

// Now, use the connection from the included database.php
$conn = new mysqli(DB_SERVER, DB_USERNAME, DB_PASSWORD, DB_NAME);

// Check connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}


// Function to execute multi-query SQL
function execute_sql($conn, $sql, $file_name) {
    if ($conn->multi_query($sql)) {
        echo "--------------------------------------------------------<br>";
        echo "Executing queries from $file_name...<br>";
        do {
            // Store first result set
            if ($result = $conn->store_result()) {
                $result->free();
            }
        } while ($conn->next_result());
        echo "$file_name executed successfully.<br>";
        echo "--------------------------------------------------------<br>";
    } else {
        echo "Error executing $file_name: " . $conn->error . "<br>";
    }
}

// Execute the SQL
execute_sql($conn, $database_sql, 'database.sql');

$update_1_queries = [
    "ALTER TABLE `users` ADD `full_name` VARCHAR(255) NOT NULL AFTER `username`",
    "ALTER TABLE `users` ADD `email` VARCHAR(255) NOT NULL AFTER `full_name`",
    "ALTER TABLE `sales_records` ADD `invoice_number` VARCHAR(255) AFTER `status`",
    "ALTER TABLE `sales_records` ADD `invoice_date` DATE AFTER `invoice_number`",
    "ALTER TABLE `sales_records` ADD `invoice_amount` DECIMAL(10, 2) AFTER `invoice_date`",
    "ALTER TABLE `sales_records` ADD `rating` INT(2) NULL DEFAULT NULL AFTER `frequency`"
];

echo "--------------------------------------------------------<br>";
echo "Executing queries from update_1.sql...<br>";
foreach ($update_1_queries as $sql) {
    if ($conn->query($sql) === TRUE) {
        // echo "Query executed successfully: $sql<br>";
    } else {
        if (strpos($conn->error, 'Duplicate column name') === false) {
            echo "Error executing query: $sql <br> " . $conn->error . "<br>";
        }
    }
}
echo "update_1.sql executed successfully.<br>";
echo "--------------------------------------------------------<br>";


execute_sql($conn, $login_history_sql, 'login_history.sql');
execute_sql($conn, $comments_sql, 'comments.sql');


// Close the connection
$conn->close();

echo "Setup complete.";

?>