<?php
if (isset($_GET['id'])) {
    $id = $_GET['id'];

    // Handle status update
    if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['status']) && strtolower($_SESSION['role']) == 'admin') {
        $status = $_POST['status'];
        $update_sql = "UPDATE sales_records SET status = ? WHERE id = ?";
        if ($update_stmt = $conn->prepare($update_sql)) {
            $update_stmt->bind_param("si", $status, $id);
            if ($update_stmt->execute()) {
                $_SESSION['message'] = "<div class='alert alert-success alert-dismissible fade show' role='alert'>Status updated successfully.<button type='button' class='btn-close' data-bs-dismiss='alert' aria-label='Close'></button></div>";
            } else {
                $_SESSION['message'] = "<div class='alert alert-danger alert-dismissible fade show' role='alert'>Error updating status.<button type='button' class='btn-close' data-bs-dismiss='alert' aria-label='Close'></button></div>";
            }
            $update_stmt->close();
            header("Location: index.php?page=view_record&id=$id");
            exit;
        }
    }

    // Handle comment submission
    if ($_SERVER["REQUEST_METHOD"] == "POST" && !empty($_POST['comment'])) {
        $comment = $_POST['comment'];
        $user_id = $_SESSION['id'];
        $insert_comment_sql = "INSERT INTO comments (record_id, user_id, comment) VALUES (?, ?, ?)";
        if ($insert_stmt = $conn->prepare($insert_comment_sql)) {
            $insert_stmt->bind_param("iis", $id, $user_id, $comment);
            if ($insert_stmt->execute()) {
                $_SESSION['message'] = "<div class='alert alert-success alert-dismissible fade show' role='alert'>Comment added successfully.<button type='button' class='btn-close' data-bs-dismiss='alert' aria-label='Close'></button></div>";
            } else {
                $_SESSION['message'] = "<div class='alert alert-danger alert-dismissible fade show' role='alert'>Error adding comment.<button type='button' class='btn-close' data-bs-dismiss='alert' aria-label='Close'></button></div>";
            }
            $insert_stmt->close();
            header("Location: index.php?page=view_record&id=$id");
            exit;
        }
    }

    // Get record details
    $sql = "SELECT * FROM sales_records WHERE id = ?";
    if ($stmt = $conn->prepare($sql)) {
        $stmt->bind_param("i", $id);
        if ($stmt->execute()) {
            $result = $stmt->get_result();
            if ($result->num_rows == 1) {
                $row = $result->fetch_assoc();
            } else {
                echo "Invalid record ID.";
                exit;
            }
        } else {
            echo "Error retrieving record.";
            exit;
        }
        $stmt->close();
    }
    
    // Get comments
    $comments_sql = "SELECT c.comment, c.created_at, u.username FROM comments c JOIN users u ON c.user_id = u.id WHERE c.record_id = ? ORDER BY c.created_at DESC";
    $comments_stmt = $conn->prepare($comments_sql);
    $comments_stmt->bind_param("i", $id);
    $comments_stmt->execute();
    $comments_result = $comments_stmt->get_result();

} else {
    echo "No record ID specified.";
    exit;
}
?>

<div class="container-fluid prospect-view">
    <?php
    if (isset($_SESSION['message'])) {
        echo $_SESSION['message'];
        unset($_SESSION['message']);
    }
    ?>
    <div class="row">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header">
                    <h3>Appointment Details</h3>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <p><strong>APPT ID:</strong> <?php echo htmlspecialchars($row['appt_id']); ?></p>
                            <p><strong>Business Name:</strong> <?php echo htmlspecialchars($row['business_name']); ?>
                            </p>
                            <p><strong>Contact Name:</strong> <?php echo htmlspecialchars($row['contact_name']); ?></p>
                            <p><strong>Contact Title:</strong> <?php echo htmlspecialchars($row['contact_title']); ?>
                            </p>
                            <p><strong>Phone:</strong> <?php echo htmlspecialchars($row['phone']); ?></p>
                            <p><strong>Email:</strong> <?php echo htmlspecialchars($row['email']); ?></p>
                            <p><strong>Address:</strong> <?php echo nl2br(htmlspecialchars($row['address'])); ?></p>
                        </div>
                        <div class="col-md-6">
                            <p><strong>Agent Name:</strong> <?php echo htmlspecialchars($row['agent_name']); ?></p>
                            <p><strong>Campaign:</strong> <?php echo htmlspecialchars($row['campaign']); ?></p>
                            <p><strong>Submission Date:</strong>
                                <?php echo htmlspecialchars($row['submission_date']); ?></p>
                            <p><strong>Appt. Date:</strong> <?php echo htmlspecialchars($row['date_of_appt']); ?></p>
                            <p><strong>Appt. Time:</strong> <?php echo date("h:i A", strtotime($row['time_of_appt'])); ?></p>
                            <p><strong>Cleaning Situation:</strong>
                                <?php echo htmlspecialchars($row['cleaning_situation']); ?></p>
                            <p><strong>Frequency:</strong> <?php echo htmlspecialchars($row['frequency']); ?></p>
                            <p><strong>Company Rating:</strong> 
                                <?php 
                                if ($row['rating'] !== null) {
                                    echo htmlspecialchars($row['rating']) . ' / 10';
                                } else {
                                    echo 'N/A';
                                }
                                ?>
                            </p>
                        </div>
                    </div>
                    <hr>
                    <p><strong>Customer Note:</strong></p>
                    <p><?php echo nl2br(htmlspecialchars($row['customer_note'])); ?></p>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card">
                <div class="card-header">
                    <h3>Status & Actions</h3>
                </div>
                <div class="card-body">
                    <?php if (strtolower($_SESSION['role']) == 'admin'): ?>
                        <form action="index.php?page=view_record&id=<?php echo $id; ?>" method="post">
                            <div class="form-group">
                                <label for="status"><strong>Status:</strong></label>
                                <select name="status" id="status" class="form-control">
                                    <option value="Reviewing" <?php echo ($row['status'] == 'Reviewing') ? 'selected' : ''; ?>>Reviewing</option>
                                    <option value="Valid" <?php echo ($row['status'] == 'Valid') ? 'selected' : ''; ?>>Valid
                                    </option>
                                    <option value="Invalid" <?php echo ($row['status'] == 'Invalid') ? 'selected' : ''; ?>>
                                        Invalid</option>
                                    <option value="Credit" <?php echo ($row['status'] == 'Credit') ? 'selected' : ''; ?>>
                                        Credit</option>
                                    <option value="Credit Till Res" <?php echo ($row['status'] == 'Credit Till Res') ? 'selected' : ''; ?>>Credit Till Res</option>
                                    <option value="Reschedule" <?php echo ($row['status'] == 'Reschedule') ? 'selected' : ''; ?>>Reschedule</option>
                                    <option value="Duplicate" <?php echo ($row['status'] == 'Duplicate') ? 'selected' : ''; ?>>Duplicate</option>
                                    <option value="Follow-up" <?php echo ($row['status'] == 'Follow-up') ? 'selected' : ''; ?>>Follow-up</option>
                                    <option value="Out Of Coverage" <?php echo ($row['status'] == 'Out Of Coverage') ? 'selected' : ''; ?>>Out Of Coverage</option>
                                    <option value="DNC" <?php echo ($row['status'] == 'DNC') ? 'selected' : ''; ?>>DNC
                                    </option>
                                    <option value="Decline" <?php echo ($row['status'] == 'Decline') ? 'selected' : ''; ?>>
                                        Decline</option>
                                    <option value="Invoiced" <?php echo ($row['status'] == 'Invoiced') ? 'selected' : ''; ?>>
                                        Invoiced</option>
                                </select>
                            </div>
                            <button type="submit" class="btn btn-primary mt-2">Update Status</button>
                        </form>
                    <?php else: ?>
                        <p><strong>Status:</strong> <?php echo htmlspecialchars($row['status']); ?></p>
                    <?php endif; ?>
                </div>
            </div>
            <div class="card mt-3">
                <div class="card-header">
                    <h3>Comments</h3>
                </div>
                <div class="card-body">
                    <form action="index.php?page=view_record&id=<?php echo $id; ?>" method="post">
                        <div class="form-group">
                            <textarea name="comment" class="form-control" rows="3"
                                placeholder="Add a comment..."></textarea>
                        </div>
                        <button type="submit" class="btn btn-primary mt-2">Add Comment</button>
                    </form>
                    <hr>
                    <div class="comment-list">
                        <?php while ($comment_row = $comments_result->fetch_assoc()): ?>
                            <div class="comment">
                                <p><strong><?php echo htmlspecialchars($comment_row['username']); ?>:</strong></p>
                                <p><?php echo nl2br(htmlspecialchars($comment_row['comment'])); ?></p>
                                <small class="text-muted"><?php echo date("d M Y, h:i A", strtotime($comment_row['created_at'])); ?></small>
                            </div>
                            <hr>
                        <?php endwhile; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>