<?php
// Get filter values from GET parameters
$search = isset($_GET['search']) ? $_GET['search'] : '';
$user_id_filter = isset($_GET['user_id']) ? $_GET['user_id'] : '';
$status_filter = isset($_GET['status']) ? $_GET['status'] : '';
$start_date = isset($_GET['start_date']) ? $_GET['start_date'] : date('Y-m-d', strtotime('-30 days'));
$end_date = isset($_GET['end_date']) ? $_GET['end_date'] : date('Y-m-d');

// Base SQL query
$sql = "SELECT * FROM sales_records WHERE 1=1";
$params = [];
$types = "";

// Apply filters
if (strtolower($_SESSION["role"]) != "admin") {
    $sql .= " AND user_id = ?";
    $params[] = $_SESSION['id'];
    $types .= "i";
} elseif (!empty($user_id_filter)) {
    $sql .= " AND user_id = ?";
    $params[] = $user_id_filter;
    $types .= "i";
}

if (!empty($search)) {
    $sql .= " AND (appt_id LIKE ? OR business_name LIKE ? OR phone LIKE ? OR email LIKE ?)";
    $search_param = "%{$search}%";
    $params = array_merge($params, [$search_param, $search_param, $search_param, $search_param]);
    $types .= "ssss";
}

if (!empty($status_filter)) {
    $sql .= " AND status = ?";
    $params[] = $status_filter;
    $types .= "s";
}

$sql .= " AND submission_date BETWEEN ? AND ?";
$params[] = $start_date;
$params[] = $end_date;
$types .= "ss";

$sql .= " ORDER BY id DESC";

$stmt = $conn->prepare($sql);
if (!empty($types)) {
    $stmt->bind_param($types, ...$params);
}
$stmt->execute();
$result = $stmt->get_result();
?>

<div class="container-fluid">
    <?php
    if (isset($_SESSION['message'])) {
        echo $_SESSION['message'];
        unset($_SESSION['message']);
    }
    ?>
    <h2>Sales Records</h2>

    <!-- Search and Filter Form -->
    <form method="GET" class="filter-form">
        <input type="hidden" name="page" value="records">
        <div class="row mb-3">
            <div class="col-md-3">
                <input type="text" name="search" class="form-control" placeholder="Search..."
                    value="<?php echo htmlspecialchars($search); ?>">
            </div>
            <?php if (strtolower($_SESSION["role"]) == "admin"): ?>
                <div class="col-md-2">
                    <select name="user_id" class="form-control">
                        <option value="">All Users</option>
                        <?php
                        $users_sql = "SELECT id, username FROM users";
                        $users_result = $conn->query($users_sql);
                        while ($user_row = $users_result->fetch_assoc()) {
                            $selected = ($user_id_filter == $user_row['id']) ? 'selected' : '';
                            echo "<option value='{$user_row['id']}' {$selected}>" . htmlspecialchars($user_row['username']) . "</option>";
                        }
                        ?>
                    </select>
                </div>
            <?php endif; ?>
            <div class="col-md-2">
                <select name="status" class="form-control">
                    <option value="">All Statuses</option>
                    <option value="Reviewing" <?php echo ($status_filter == 'Reviewing') ? 'selected' : ''; ?>>Reviewing
                    </option>
                    <option value="Valid" <?php echo ($status_filter == 'Valid') ? 'selected' : ''; ?>>Valid</option>
                    <option value="Invalid" <?php echo ($status_filter == 'Invalid') ? 'selected' : ''; ?>>Invalid
                    </option>
                    <option value="Credit" <?php echo ($status_filter == 'Credit') ? 'selected' : ''; ?>>Credit</option>
                    <option value="Credit Till Res" <?php echo ($status_filter == 'Credit Till Res') ? 'selected' : ''; ?>>Credit Till Res</option>
                    <option value="Reschedule" <?php echo ($status_filter == 'Reschedule') ? 'selected' : ''; ?>>
                        Reschedule</option>
                    <option value="Duplicate" <?php echo ($status_filter == 'Duplicate') ? 'selected' : ''; ?>>Duplicate
                    </option>
                    <option value="Follow-up" <?php echo ($status_filter == 'Follow-up') ? 'selected' : ''; ?>>Follow-up
                    </option>
                    <option value="Out Of Coverage" <?php echo ($status_filter == 'Out Of Coverage') ? 'selected' : ''; ?>>Out Of Coverage</option>
                    <option value="DNC" <?php echo ($status_filter == 'DNC') ? 'selected' : ''; ?>>DNC</option>
                    <option value="Decline" <?php echo ($status_filter == 'Decline') ? 'selected' : ''; ?>>Decline
                    </option>
                    <option value="Invoiced" <?php echo ($status_filter == 'Invoiced') ? 'selected' : ''; ?>>Invoiced
                    </option>
                </select>
            </div>
            <div class="col-md-3">
                <div class="input-group">
                    <input type="date" name="start_date" class="form-control" value="<?php echo $start_date; ?>">
                    <input type="date" name="end_date" class="form-control" value="<?php echo $end_date; ?>">
                </div>
            </div>
            <div class="col-md-2">
                <button type="submit" class="btn btn-primary">Filter</button>
            </div>
        </div>
    </form>

    <table class="table table-bordered table-striped table-modern">
        <thead>
            <tr>
                <th>Appt. ID</th>
                <th>Agent Name</th>
                <th>Business Name</th>
                <th>Contact Name</th>
                <th>Appt. Date</th>
                <th>Appt. Time</th>
                <th>Campaign</th>
                <th>Status</th>
                <th>Action</th>
            </tr>
        </thead>
        <tbody>
            <?php
            if ($result->num_rows > 0) {
                while ($row = $result->fetch_assoc()) {
                    echo "<tr>";
                    echo "<td>" . htmlspecialchars($row['appt_id']) . "</td>";
                    echo "<td>" . htmlspecialchars($row['agent_name']) . "</td>";
                    echo "<td>" . htmlspecialchars($row['business_name']) . "</td>";
                    echo "<td>" . htmlspecialchars($row['contact_name']) . "</td>";
                    echo "<td>" . htmlspecialchars($row['date_of_appt']) . "</td>";
                    echo "<td>" . date("h:i A", strtotime($row['time_of_appt'])) . "</td>";
                    echo "<td>" . htmlspecialchars($row['campaign']) . "</td>";
                    echo "<td>" . htmlspecialchars($row['status']) . "</td>";
                    echo "<td>";
                    if (strtolower($_SESSION['role']) == 'admin') {
                        // Admin can Edit, View, Delete
                        echo "<a href='index.php?page=edit_record&id=" . $row['id'] . "' class='btn btn-primary btn-sm me-1' title='Edit'><i class='fas fa-edit'></i></a>";
                        echo "<a href='index.php?page=view_record&id=" . $row['id'] . "' class='btn btn-info btn-sm me-1' title='View'><i class='fas fa-eye'></i></a>";
                        echo "<a href='index.php?page=delete_record&id=" . $row['id'] . "' class='btn btn-danger btn-sm' title='Delete' onclick='return confirm(\"Are you sure you want to delete this record?\")'><i class='fas fa-trash'></i></a>";
                    } else {
                        // Agent can only View
                        echo "<a href='index.php?page=view_record&id=" . $row['id'] . "' class='btn btn-info btn-sm' title='View'><i class='fas fa-eye'></i></a>";
                    }
                    echo "</td>";
                    echo "</tr>";
                }
            } else {
                echo "<tr><td colspan='9'>No records found.</td></tr>";
            }
            ?>
        </tbody>
    </table>
</div>