
<?php
// pages/login_history.php

require_once '../includes/auth.php';
require_once '../config/database.php';

if (!is_logged_in() || !is_admin()) {
    header("location: ../index.php?page=login");
    exit;
}

// Fetch users for the filter dropdown
$users_sql = "SELECT id, username FROM users";
$users_result = $conn->query($users_sql);

// Filter by user
$user_filter = isset($_GET['user_id']) ? (int)$_GET['user_id'] : 0;
$status_filter = isset($_GET['status']) ? $_GET['status'] : '';

$sql = "SELECT lh.id, u.username, lh.login_time, lh.ip_address, lh.status FROM login_history lh JOIN users u ON lh.user_id = u.id";

$params = [];
$types = '';

if ($user_filter > 0) {
    $sql .= " WHERE lh.user_id = ?";
    $params[] = $user_filter;
    $types .= 'i';
}

if (!empty($status_filter)) {
    if ($user_filter > 0) {
        $sql .= " AND lh.status = ?";
    } else {
        $sql .= " WHERE lh.status = ?";
    }
    $params[] = $status_filter;
    $types .= 's';
}

$sql .= " ORDER BY lh.login_time DESC";

$stmt = $conn->prepare($sql);

if (!empty($params)) {
    $stmt->bind_param($types, ...$params);
}

$stmt->execute();
$result = $stmt->get_result();

?>

<?php include '../includes/header.php'; ?>

<div class="container-fluid">
    <div class="row">
        <?php include '../includes/sidebar.php'; ?>

        <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4">
            <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
                <h1 class="h2">Login History</h1>
                <div class="btn-toolbar mb-2 mb-md-0">
                    <form action="" method="GET" class="form-inline">
                        <input type="hidden" name="page" value="login_history">
                        <select name="user_id" class="form-control mr-2" onchange="this.form.submit()">
                            <option value="0">All Users</option>
                            <?php while($user = $users_result->fetch_assoc()): ?>
                                <option value="<?php echo $user['id']; ?>" <?php if($user_filter == $user['id']) echo 'selected'; ?>><?php echo $user['username']; ?></option>
                            <?php endwhile; ?>
                        </select>
                        <select name="status" class="form-control" onchange="this.form.submit()">
                            <option value="">All Statuses</option>
                            <option value="success" <?php if($status_filter == 'success') echo 'selected'; ?>>Success</option>
                            <option value="failed" <?php if($status_filter == 'failed') echo 'selected'; ?>>Failed</option>
                        </select>
                    </form>
                </div>
            </div>

            <div class="table-responsive">
                <table class="table table-striped table-sm">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Username</th>
                            <th>Login Time</th>
                            <th>IP Address</th>
                            <th>Status</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if ($result->num_rows > 0): ?>
                            <?php while($row = $result->fetch_assoc()): ?>
                                <tr>
                                    <td><?php echo $row['id']; ?></td>
                                    <td><?php echo $row['username']; ?></td>
                                    <td><?php echo $row['login_time']; ?></td>
                                    <td><?php echo $row['ip_address']; ?></td>
                                    <td><?php echo $row['status']; ?></td>
                                </tr>
                            <?php endwhile; ?>
                        <?php else: ?>
                            <tr>
                                <td colspan="5">No login history found.</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </main>
    </div>
</div>

<?php include '../includes/footer.php'; ?>
