<?php
if (isset($_GET['id'])) {
    $id = $_GET['id'];

    if ($_SERVER["REQUEST_METHOD"] == "POST") {
        $appt_id = $_POST['appt_id'];
        $submission_date = $_POST['submission_date'];
        $agent_name = $_POST['agent_name'];
        $campaign = $_POST['campaign'];
        $date_of_appt = $_POST['date_of_appt'];
        $time_of_appt = $_POST['time_of_appt'];
        $cleaning_situation = $_POST['cleaning_situation'];
        $frequency = $_POST['frequency'];
        $phone = $_POST['phone'];
        $email = $_POST['email'];
        $contact_name = $_POST['contact_name'];
        $contact_title = $_POST['contact_title'];
        $business_name = $_POST['business_name'];
        $address = $_POST['address'];
        $customer_note = $_POST['customer_note'];
        $status = $_POST['status'];

        $sql = "UPDATE sales_records SET appt_id=?, submission_date=?, agent_name=?, campaign=?, date_of_appt=?, time_of_appt=?, cleaning_situation=?, frequency=?, phone=?, email=?, contact_name=?, contact_title=?, business_name=?, address=?, customer_note=?, status=? WHERE id=?";

        if ($stmt = $conn->prepare($sql)) {
            $stmt->bind_param("ssssssssssssssssi", $appt_id, $submission_date, $agent_name, $campaign, $date_of_appt, $time_of_appt, $cleaning_situation, $frequency, $phone, $email, $contact_name, $contact_title, $business_name, $address, $customer_note, $status, $id);
            
            if ($stmt->execute()) {
                echo "<div class='alert alert-success'>Record updated successfully.</div>";
            } else {
                echo "<div class='alert alert-danger'>Error: " . $stmt->error . "</div>";
            }
            $stmt->close();
        }
    }

    $sql = "SELECT * FROM sales_records WHERE id = ?";
    if ($stmt = $conn->prepare($sql)) {
        $stmt->bind_param("i", $id);
        if ($stmt->execute()) {
            $result = $stmt->get_result();
            if ($result->num_rows == 1) {
                $row = $result->fetch_assoc();
            } else {
                echo "Invalid record ID.";
                exit;
            }
        } else {
            echo "Error retrieving record.";
            exit;
        }
        $stmt->close();
    }
} else {
    echo "No record ID specified.";
    exit;
}
?>

<div class="container-fluid">
    <h2>Edit Sales Record</h2>
    <form action="index.php?page=edit_record&id=<?php echo $id; ?>" method="post">
        <div class="row">
            <div class="col-md-6">
                <div class="form-group">
                    <label>APPT ID</label>
                    <input type="text" name="appt_id" class="form-control" value="<?php echo $row['appt_id']; ?>" required>
                </div>
                <div class="form-group">
                    <label>Submission Date</label>
                    <input type="date" name="submission_date" class="form-control" value="<?php echo $row['submission_date']; ?>" required>
                </div>
                <div class="form-group">
                    <label>Agent Name</label>
                    <input type="text" name="agent_name" class="form-control" value="<?php echo $row['agent_name']; ?>" readonly>
                </div>
                <div class="form-group">
                    <label>Campaign</label>
                    <input type="text" name="campaign" class="form-control" value="<?php echo $row['campaign']; ?>" required>
                </div>
                <div class="form-group">
                    <label>Date of Appt.</label>
                    <input type="date" name="date_of_appt" class="form-control" value="<?php echo $row['date_of_appt']; ?>" required>
                </div>
                <div class="form-group">
                    <label>Time of Appt.</label>
                    <input type="time" name="time_of_appt" class="form-control" value="<?php echo $row['time_of_appt']; ?>" required>
                </div>
                <div class="form-group">
                    <label>Cleaning Situation</label>
                    <input type="text" name="cleaning_situation" class="form-control" value="<?php echo $row['cleaning_situation']; ?>">
                </div>
                <div class="form-group">
                    <label>Frequency</label>
                    <input type="text" name="frequency" class="form-control" value="<?php echo $row['frequency']; ?>">
                </div>
            </div>
            <div class="col-md-6">
                <div class="form-group">
                    <label>Phone</label>
                    <input type="text" name="phone" class="form-control" value="<?php echo $row['phone']; ?>">
                </div>
                <div class="form-group">
                    <label>Email</label>
                    <input type="email" name="email" class="form-control" value="<?php echo $row['email']; ?>">
                </div>
                <div class="form-group">
                    <label>Contact Name</label>
                    <input type="text" name="contact_name" class="form-control" value="<?php echo $row['contact_name']; ?>">
                </div>
                <div class="form-group">
                    <label>Contact Title</label>
                    <input type="text" name="contact_title" class="form-control" value="<?php echo $row['contact_title']; ?>">
                </div>
                <div class="form-group">
                    <label>Business Name</label>
                    <input type="text" name="business_name" class="form-control" value="<?php echo $row['business_name']; ?>">
                </div>
                <div class="form-group">
                    <label>Address</label>
                    <textarea name="address" class="form-control"><?php echo $row['address']; ?></textarea>
                </div>
                <div class="form-group">
                    <label>Customer Note</label>
                    <textarea name="customer_note" class="form-control"><?php echo $row['customer_note']; ?></textarea>
                </div>
                <div class="form-group">
                    <label>Status</label>
                    <select name="status" class="form-control">
                        <option value="Reviewing" <?php echo ($row['status'] == 'Reviewing') ? 'selected' : ''; ?>>Reviewing</option>
                        <option value="Valid" <?php echo ($row['status'] == 'Valid') ? 'selected' : ''; ?>>Valid</option>
                        <option value="Invalid" <?php echo ($row['status'] == 'Invalid') ? 'selected' : ''; ?>>Invalid</option>
                        <option value="Credit" <?php echo ($row['status'] == 'Credit') ? 'selected' : ''; ?>>Credit</option>
                        <option value="Credit Till Res" <?php echo ($row['status'] == 'Credit Till Res') ? 'selected' : ''; ?>>Credit Till Res</option>
                        <option value="Reschedule" <?php echo ($row['status'] == 'Reschedule') ? 'selected' : ''; ?>>Reschedule</option>
                        <option value="Duplicate" <?php echo ($row['status'] == 'Duplicate') ? 'selected' : ''; ?>>Duplicate</option>
                        <option value="Follow-up" <?php echo ($row['status'] == 'Follow-up') ? 'selected' : ''; ?>>Follow-up</option>
                        <option value="Out Of Coverage" <?php echo ($row['status'] == 'Out Of Coverage') ? 'selected' : ''; ?>>Out Of Coverage</option>
                        <option value="DNC" <?php echo ($row['status'] == 'DNC') ? 'selected' : ''; ?>>DNC</option>
                        <option value="Decline" <?php echo ($row['status'] == 'Decline') ? 'selected' : ''; ?>>Decline</option>
                        <option value="Invoiced" <?php echo ($row['status'] == 'Invoiced') ? 'selected' : ''; ?>>Invoiced</option>
                    </select>
                </div>
            </div>
        </div>
        <button type="submit" class="btn btn-primary">Update</button>
        <a href="index.php?page=records" class="btn btn-secondary">Cancel</a>
    </form>
</div>