<?php
if (isset($_GET['id'])) {
    // Check if user is admin
    if (strtolower($_SESSION['role']) != 'admin') {
        echo "You are not authorized to perform this action.";
        exit;
    }

    $id = $_GET['id'];

    $sql = "DELETE FROM sales_records WHERE id = ?";
    if ($stmt = $conn->prepare($sql)) {
        $stmt->bind_param("i", $id);
        if ($stmt->execute()) {
            // Redirect back to the records page with a success message
            $_SESSION['message'] = "<div class='alert alert-success'>Record deleted successfully.</div>";
            header("Location: index.php?page=records");
            exit();
        } else {
            // Redirect back to the records page with an error message
            $_SESSION['message'] = "<div class='alert alert-danger'>Error deleting record: " . $conn->error . "</div>";
            header("Location: index.php?page=records");
            exit();
        }
        $stmt->close();
    }
} else {
    // Redirect back to the records page if no ID is specified
    header("Location: index.php?page=records");
    exit();
}
?>