<?php
// Generate new Appt ID
$sql_get_last_id = "SELECT appt_id FROM sales_records ORDER BY id DESC LIMIT 1";
$result_last_id = $conn->query($sql_get_last_id);
$last_id_nr = 100;
if ($result_last_id && $result_last_id->num_rows > 0) {
    $row_last_id = $result_last_id->fetch_assoc();
    if ($row_last_id['appt_id']) {
        $last_id_nr = (int) str_replace('#', '', $row_last_id['appt_id']);
    }
}
$new_appt_id = '#' . ($last_id_nr + 1);


if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $appt_id = $_POST['appt_id'];
    $submission_date = $_POST['submission_date'];
    $agent_name = $_POST['agent_name'];
    $campaign = $_POST['campaign'];
    $date_of_appt = $_POST['date_of_appt'];
    $time_of_appt = $_POST['time_of_appt'];
    $cleaning_situation = $_POST['cleaning_situation'];
    $frequency = $_POST['frequency'];
    $rating = $_POST['rating'];
    if ($rating == 0) {
        $rating = NULL;
    }
    $phone = $_POST['phone'];
    $email = $_POST['email'];
    $contact_name = $_POST['contact_name'];
    $contact_title = $_POST['contact_title'];
    $business_name = $_POST['business_name'];
    $address = $_POST['address'];
    $customer_note = $_POST['customer_note'];
    $status = 'Reviewing'; // Set status to Reviewing by default
    $user_id = $_SESSION['id'];

    $sql = "INSERT INTO sales_records (appt_id, submission_date, agent_name, campaign, date_of_appt, time_of_appt, cleaning_situation, frequency, rating, phone, email, contact_name, contact_title, business_name, address, customer_note, status, user_id) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";

    if ($stmt = $conn->prepare($sql)) {
        $stmt->bind_param("ssssssssissssssssi", $appt_id, $submission_date, $agent_name, $campaign, $date_of_appt, $time_of_appt, $cleaning_situation, $frequency, $rating, $phone, $email, $contact_name, $contact_title, $business_name, $address, $customer_note, $status, $user_id);
        
        if ($stmt->execute()) {
            $_SESSION['message'] = "<div class='alert alert-success alert-dismissible fade show' role='alert'>Record added successfully.<button type='button' class='btn-close' data-bs-dismiss='alert' aria-label='Close'></button></div>";
        } else {
            $_SESSION['message'] = "<div class='alert alert-danger alert-dismissible fade show' role='alert'>Error adding record.<button type='button' class='btn-close' data-bs-dismiss='alert' aria-label='Close'></button></div>";
        }
        $stmt->close();
        header("Location: index.php?page=add_record");
        exit;
    }
}
?>

<div class="container-fluid">
    <?php
    if (isset($_SESSION['message'])) {
        echo $_SESSION['message'];
        unset($_SESSION['message']);
    }
    ?>
    <h2>Add New Sales Record</h2>
    <form action="index.php?page=add_record" method="post">
        <div class="row">
            <div class="col-md-6">
                <div class="form-group">
                    <label>APPT ID</label>
                    <input type="text" name="appt_id" class="form-control" value="<?php echo $new_appt_id; ?>" readonly>
                </div>
                <div class="form-group">
                    <label>Submission Date</label>
                    <input type="date" name="submission_date" class="form-control" value="<?php echo date('Y-m-d'); ?>" required>
                </div>
                <div class="form-group">
                    <label>Agent Name</label>
                    <input type="text" name="agent_name" class="form-control" value="<?php echo $_SESSION['username']; ?>" readonly>
                </div>
                <div class="form-group">
                    <label>Campaign</label>
                    <input type="text" name="campaign" class="form-control" required>
                </div>
                <div class="form-group">
                    <label>Date of Appt.</label>
                    <input type="date" name="date_of_appt" class="form-control" required>
                </div>
                <div class="form-group">
                    <label>Time of Appt.</label>
                    <input type="time" name="time_of_appt" class="form-control" required>
                </div>
                <div class="form-group">
                    <label>Cleaning Situation</label>
                    <select name="cleaning_situation" class="form-control">
                        <option value="Inhouse">Inhouse</option>
                        <option value="Outsourced">Outsourced</option>
                        <option value="Inhouse & outsourced both">Inhouse & outsourced both</option>
                    </select>
                </div>
                <div class="form-group">
                    <label>Frequency</label>
                    <select name="frequency" class="form-control">
                        <option value="1x in a week">1x in a week</option>
                        <option value="2x in a week">2x in a week</option>
                        <option value="3x in a week">3x in a week</option>
                        <option value="4x in a week">4x in a week</option>
                        <option value="5x in a week">5x in a week</option>
                        <option value="6x in a week">6x in a week</option>
                        <option value="7x in a week">7x in a week</option>
                    </select>
                </div>
                <div class="form-group">
                    <label>Current Company Rating</label>
                    <input type="number" name="rating" class="form-control" min="0" max="10" value="0">
                </div>
            </div>
            <div class="col-md-6">
                <div class="form-group">
                    <label>Phone</label>
                    <input type="text" name="phone" class="form-control">
                </div>
                <div class="form-group">
                    <label>Email</label>
                    <input type="email" name="email" class="form-control">
                </div>
                <div class="form-group">
                    <label>Contact Name</label>
                    <input type="text" name="contact_name" class="form-control">
                </div>
                <div class="form-group">
                    <label>Contact Title</label>
                    <input type="text" name="contact_title" class="form-control">
                </div>
                <div class="form-group">
                    <label>Business Name</label>
                    <input type="text" name="business_name" class="form-control">
                </div>
                <div class="form-group">
                    <label>Address</label>
                    <textarea name="address" class="form-control"></textarea>
                </div>
                <div class="form-group">
                    <label>Customer Note</label>
                    <textarea name="customer_note" class="form-control"></textarea>
                </div>
            </div>
        </div>
        <button type="submit" class="btn btn-primary btn-wonderful">Submit</button>
    </form>
</div>