<?php
session_start();

// Check if the user is logged in, otherwise redirect to login page
if (!isset($_SESSION["loggedin"]) || $_SESSION["loggedin"] !== true) {
    header("location: pages/login.php");
    exit;
}

require_once 'config/database.php';
require_once 'includes/header.php';
require_once 'includes/sidebar.php';

$page = isset($_GET['page']) ? $_GET['page'] : 'dashboard';
$allowed_pages = ['dashboard', 'records', 'add_record', 'edit_record', 'users', 'reports', 'logout', 'add_user', 'profile', 'view_record', 'delete_record'];

if (in_array($page, $allowed_pages)) {
    include 'pages/' . $page . '.php';
} else {
    include 'pages/dashboard.php';
}

require_once 'includes/footer.php';
?>