<?php
function is_logged_in()
{
    return isset($_SESSION['user_id']);
}

function is_admin()
{
    return isset($_SESSION['user_role']) && $_SESSION['user_role'] === 'admin';
}

function get_user_records($user_id, $pdo)
{
    if (is_admin()) {
        $stmt = $pdo->query("SELECT * FROM sales_records ORDER BY created_at DESC");
    } else {
        $stmt = $pdo->prepare("SELECT * FROM sales_records WHERE user_id = ? ORDER BY created_at DESC");
        $stmt->execute([$user_id]);
    }
    return $stmt->fetchAll(PDO::FETCH_ASSOC);
}
?>