<?php
require_once 'config/database.php';

$username = 'admin';
$password = 'admin123'; // New password
$hashed_password = password_hash($password, PASSWORD_DEFAULT);
$role = 'Admin';

// Check if admin user exists
$sql_check = "SELECT id FROM users WHERE username = ?";
if($stmt_check = $conn->prepare($sql_check)){
    $stmt_check->bind_param("s", $username);
    $stmt_check->execute();
    $stmt_check->store_result();
    
    if($stmt_check->num_rows > 0){
        // Update existing admin
        $sql = "UPDATE users SET password = ? WHERE username = ?";
        if($stmt = $conn->prepare($sql)){
            $stmt->bind_param("ss", $hashed_password, $username);
            if($stmt->execute()){
                echo "<h1>Admin Password Updated</h1><p>The admin password has been successfully updated to: <strong>" . $password . "</strong></p><p>You can now <a href='pages/login.php'>login</a>. Please delete this file (`hash_password.php`) for security reasons.";
            } else {
                echo "Error updating password.";
            }
            $stmt->close();
        }
    } else {
        // Insert new admin user
        $sql = "INSERT INTO users (username, password, role) VALUES (?, ?, ?)";
        if($stmt = $conn->prepare($sql)){
            $stmt->bind_param("sss", $username, $hashed_password, $role);
            if($stmt->execute()){
                echo "<h1>Admin User Created</h1><p>An admin user has been created with the password: <strong>" . $password . "</strong></p><p>You can now <a href='pages/login.php'>login</a>. Please delete this file (`hash_password.php`) for security reasons.";
            } else {
                echo "Error creating admin user.";
            }
            $stmt->close();
        }
    }
    $stmt_check->close();
}
$conn->close();
?>